#include "AutoItTemplate.au3"
#include "Registry.au3"
#NoTrayIcon

$DefaultExeName = "AviScreen.exe";
$DefaultAppDir = "App\aviscreen";
$DefaultDataDir = "Data\settings";

SetAppName("AviScreen");

Dim $exeName;
Dim $appDir;
Dim $dataDir;
Dim $aditionalParameters;
Dim $disableSpashScreen;
ReadIniFile("AviScreenPortable.ini", "AviScreenPortable", $exeName, $appDir, $dataDir, $aditionalParameters, $disableSpashScreen);

RequireNotRunning($exeName);

If DirGetSize(@ScriptDir & "\" & $dataDir, 2) == -1 Then
	DirCopy(@ScriptDir & "\App\DefaultData", @ScriptDir & "\" & $dataDir, 1);
EndIf

Dim $anyBobyteRegPath = False;
Dim $aviScreenInstalled = False;

Const $regPath = "HKEY_CURRENT_USER\Software\Bobyte\AviScreen";
Const $bobyteRegPath = "HKEY_CURRENT_USER\Software\Bobyte";

RegRead($bobyteRegPath, "");
If @error == -1 Then
	
	$anyBobyteRegPath = True;
	
	RegRead($regPath, "");
	If @error == -1 Then
		;;RunWait('regedit /E "' & StringReplace(@ScriptDir & '\' & $dataDir & '\local.reg', '"', '""') & '" "' & $regPath & '"');
		_RegExport(@ScriptDir & '\' & $dataDir & '\local.reg', $regPath);
		$aviScreenInstalled = True;
		RegDelete($regPath);
	EndIf

EndIf

;;RunWait('regedit.exe /S "' & StringReplace(@ScriptDir & '\' & $dataDir & '\' & "settings.reg", '"', '""') & '"');
_RegImport(@ScriptDir & '\' & $dataDir & "\settings.reg");

Dim $proc = Run('"' & StringReplace(@ScriptDir & '\' & $appDir & '\' & $exeName, '"', '""') & '" ' & $aditionalParameters & ' ' & $cmdLineRaw, @ScriptDir & '\' & $appDir);

If Not $disableSpashScreen Then
	DirCreate(@TempDir & "\AviScreenPortable");
	FileInstall("AviScreenPortable.jpg", @TempDir & "\AviScreenPortable\", 1);
	SplashImageOn("AviScreen Portable", @TempDir & "\AviScreenPortable\AviScreenPortable.jpg", 205, 119);
	Sleep(1200);
	SplashOff();
	DirRemove(@TempDir & "\AviScreenPortable", 1);
EndIf

While ProcessExists($proc)
	Sleep(1000);
WEnd

;;RunWait('regedit.exe /E "' & StringReplace(@ScriptDir & '\' & $dataDir & '\settings.reg', '"', '""') & '" "' & $regPath & '"');
_RegExport(@ScriptDir & '\' & $dataDir & '\settings.reg', $regPath);
Sleep(200);
RegDelete($regPath);
If Not $anyBobyteRegPath Then
	RegDelete($bobyteRegPath);
EndIf

If $aviScreenInstalled Then
	;;RunWait('regedit.exe /S "' & StringReplace(@ScriptDir & '\' & $dataDir & '\' & "local.reg", '"', '""') & '"');
	_RegImport(@ScriptDir & '\' & $dataDir & '\' & "local.reg");
	FileDelete(@ScriptDir & '\' & $dataDir & "\local.reg");
EndIf